import { jsx, jsxs } from "react/jsx-runtime";
import * as T from "@radix-ui/react-toast";
import { useEditor } from "@tldraw/editor";
import * as React from "react";
import { useToasts } from "../context/toasts.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "./primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonLabel } from "./primitives/Button/TldrawUiButtonLabel.mjs";
import { TldrawUiIcon } from "./primitives/TldrawUiIcon.mjs";
const SEVERITY_TO_ICON = {
  success: "check-circle",
  warning: "warning-triangle",
  error: "cross-circle",
  info: "info-circle"
};
function Toast({ toast }) {
  const { removeToast } = useToasts();
  const msg = useTranslation();
  const onOpenChange = (isOpen) => {
    if (!isOpen) {
      removeToast(toast.id);
    }
  };
  const hasActions = toast.actions && toast.actions.length > 0;
  const icon = toast.icon || toast.severity && SEVERITY_TO_ICON[toast.severity];
  return /* @__PURE__ */ jsxs(
    T.Root,
    {
      onOpenChange,
      className: "tlui-toast__container",
      duration: toast.keepOpen ? Infinity : 5e3,
      "data-severity": toast.severity,
      children: [
        icon && /* @__PURE__ */ jsx("div", { className: "tlui-toast__icon", children: /* @__PURE__ */ jsx(TldrawUiIcon, { icon }) }),
        /* @__PURE__ */ jsxs("div", { className: "tlui-toast__main", children: [
          /* @__PURE__ */ jsxs("div", { className: "tlui-toast__content", children: [
            toast.title && /* @__PURE__ */ jsx(T.Title, { className: "tlui-toast__title", children: toast.title }),
            toast.description && /* @__PURE__ */ jsx(T.Description, { className: "tlui-toast__description", children: toast.description })
          ] }),
          toast.actions && /* @__PURE__ */ jsxs("div", { className: "tlui-toast__actions", children: [
            toast.actions.map((action, i) => /* @__PURE__ */ jsx(T.Action, { altText: action.label, asChild: true, onClick: action.onClick, children: /* @__PURE__ */ jsx(TldrawUiButton, { type: action.type, children: /* @__PURE__ */ jsx(TldrawUiButtonLabel, { children: action.label }) }) }, i)),
            /* @__PURE__ */ jsx(T.Close, { asChild: true, children: /* @__PURE__ */ jsx(
              TldrawUiButton,
              {
                type: "normal",
                className: "tlui-toast__close",
                style: { marginLeft: "auto" },
                children: /* @__PURE__ */ jsx(TldrawUiButtonLabel, { children: toast.closeLabel ?? msg("toast.close") })
              }
            ) })
          ] })
        ] }),
        !hasActions && /* @__PURE__ */ jsx(T.Close, { asChild: true, children: /* @__PURE__ */ jsx(TldrawUiButton, { type: "normal", className: "tlui-toast__close", children: /* @__PURE__ */ jsx(TldrawUiButtonLabel, { children: toast.closeLabel ?? msg("toast.close") }) }) })
      ]
    }
  );
}
function _Toasts() {
  const { toasts } = useToasts();
  return toasts.map((toast) => /* @__PURE__ */ jsx(Toast, { toast }, toast.id));
}
const Toasts = React.memo(_Toasts);
function ToastViewport() {
  const editor = useEditor();
  const { toasts } = useToasts();
  const [hasToasts, setHasToasts] = React.useState(false);
  React.useEffect(() => {
    let timeoutId = -1;
    if (toasts.length) {
      setHasToasts(true);
    } else {
      timeoutId = editor.timers.setTimeout(() => {
        setHasToasts(false);
      }, 1e3);
    }
    return () => {
      clearTimeout(timeoutId);
    };
  }, [toasts.length, setHasToasts, editor]);
  if (!hasToasts) return null;
  return /* @__PURE__ */ jsx(T.ToastViewport, { className: "tlui-toast__viewport" });
}
export {
  ToastViewport,
  Toasts
};
//# sourceMappingURL=Toasts.mjs.map
